/*****************************************************************************
*  LPC4357 SCT demoprogram
*
*  1. Use SCT timer to generate a PWM output signal @ SCT_OUT0
*  2. Every time P4_0 goes high to low increase the duty cycle.
*  3. Every time P4_3 goes high to low decrease the duty cycle.
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

int main (void) 
{
  static uint8_t trg1 = 1;
  static uint8_t trg2 = 1;

    SystemCoreClockUpdate ();                          // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);              // enable SCT clock in CCU1 

    MCB4300_Init();                                    // Initialize MCB4300 board stuff
    SCT_Init();                                        // Initialize SCT1

    while (1)                                          // loop forever
    {
        if (!(SWP4_0) && trg1)                         // SWP4_0 high to low?
        {
            trg1 = 0;                                  // trigger P4.0 low
            if (LPC_SCT->MATCHREL[1].L < 19)
                LPC_SCT->MATCHREL[1].L ++;             // increase PWM dutycycle
        }
        else if ((SWP4_0) && !trg1)                    // P4.0 low to high?
        {
            trg1 = 1;                                  // trigger P4.0 high
        }

        if (!(SWP4_3) && trg2)                         // P4.3 high to low?
        {
            trg2 = 0;                                  // trigger P4.3 low
            if (LPC_SCT->MATCHREL[1].L > 0)
                LPC_SCT->MATCHREL[1].L --;             // increase PWM dutycycle
        }
        else if ((SWP4_3) && !trg2)                    // P4.3 low to high?
        {
            trg2 = 1;                                  // trigger P4.3 high
        }
    }
}
